/*
 *  htk_buffer.h
 *
 *  Description: Circular FIFO
 *  Created on: Feb 06, 2020
 *      Author: CrystalSu
 */

#ifndef HTK_BUFFER_H_
#define HTK_BUFFER_H_

#include "ht32.h"

/**
 *  Definition of a serial ring buffer
 */
typedef struct {
  uint8_t * buffer;  // Pointer to the memory where the buffer resides
  uint8_t * read;    // Pointer to the current read position within the buffer
  uint8_t * write;   // Pointer to the current write position within the buffer
  uint16_t  maxSize; // Maximum buffer size
  uint16_t  entries; // Number of bytes currently in the buffer
} serial_RB_t;

void htk_ringBufferInit(__IO serial_RB_t * rb, uint8_t * buffer, uint16_t size);
uint8_t htk_ringBufferWrite(__IO serial_RB_t * rb, uint8_t data);
uint8_t htk_ringBufferRead(__IO serial_RB_t * rb, uint8_t * data);
void htk_ringBufferFlush(__IO serial_RB_t * rb);

#endif /* HTK_BUFFER_H_ */
